#include <16F877A.h>
#use delay(crystal=20MHz)

// Pick ONE example:
#define RUN_LED_BLINK
//#define RUN_SWITCH
//#define RUN_UART
//#define RUN_ADC
//#define RUN_EEPROM
//#define RUN_PWM

//-------------------------------------
void demo_led_blink() {
   while(TRUE) {
      output_high(PIN_B5);
      delay_ms(1000);
      output_low(PIN_B5);
      delay_ms(1000);
      
      // Shorter way
      //output_toggle(PIN_B5);
      //delay_ms(1000);
   }
}

//-------------------------------------
void demo_switch() {
   while(TRUE) {
      if(input(PIN_A4))
         output_high(PIN_B4);
      else
         output_low(PIN_B4);
   }
}

//-------------------------------------
// UART setup (used in some demos)
#use rs232(baud=9600, xmit=PIN_C6, rcv=PIN_C7)

void demo_uart() {
   printf("Hello from PIC16F877A!\r\n");
   while(TRUE) {
      char c = getc();
      printf("You typed: %c\r\n", c);
   }
}

//-------------------------------------
void demo_adc() {
   int16 value;
   setup_adc_ports(ALL_ANALOG);
   setup_adc(ADC_CLOCK_DIV_32);
   set_adc_channel(0); // AN0
   while(TRUE) {
      delay_ms(500);
      value = read_adc(); // 0 - 255
      printf("ADC Value: %lu\r\n", value);
   }
}

//-------------------------------------
void demo_eeprom() {
   int8 val;
   write_eeprom(0, 123);
   val = read_eeprom(0);
   printf("EEPROM read: %u\r\n", val);
   while(TRUE);
}

//-------------------------------------
// Hardware PWM at 1 kHz
#use pwm(CCP1, frequency=1000, duty=10)

void demo_pwm() {
   while(TRUE) {
      pwm_set_duty_percent(100);   // Resolution is 0.1%, so 100 = 10.0%
      delay_ms(1000);
      pwm_set_duty_percent(1000);  // 100%
      delay_ms(1000);
   }
}

//-------------------------------------
void main() {
   #ifdef RUN_LED_BLINK
      demo_led_blink();
   #endif

   #ifdef RUN_SWITCH
      demo_switch();
   #endif

   #ifdef RUN_UART
      demo_uart();
   #endif

   #ifdef RUN_ADC
      demo_adc();
   #endif

   #ifdef RUN_EEPROM
      demo_eeprom();
   #endif

   #ifdef RUN_PWM
      demo_pwm();
   #endif
}

